using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.UI.Windows.Forms;
using MicroFour.StrataFrame.Extensibility;
using MicroFour.StrataFrame.Security;
using StrataFlix.UI.BrowseDialogs;
using StrataFlix.Business;
using System.ComponentModel;
using System.Drawing.Design;
using System.Windows.Forms;


namespace StrataFlix.UI
{
	namespace UI
	{
		namespace Windows
		{
			namespace Forms
			{
				
				
				public partial class PeopleLookupControl : IBusinessBindable
				{
					
					
					#region " Constructors "
					
					/// <summary>
					/// Default Constructor
					/// </summary>
					/// <remarks></remarks>
					public PeopleLookupControl()
					{
						
						//-- Init the controls
						this.InitializeComponent();
						
						//-- Bind the code to the textbox
						this.txtCode.DataBindings.Add("Text", this, "Code", true, DataSourceUpdateMode.OnPropertyChanged);
						
					}
					
					#endregion
					
					#region " Events "
					
					/// <summary>
					/// Occurs when the return value of the PrimaryKey property changes.
					/// </summary>
					/// <remarks></remarks>
					private EventHandler CodeChangedEvent;
					public event EventHandler CodeChanged
					{
						add
						{
							CodeChangedEvent = (EventHandler) System.Delegate.Combine(CodeChangedEvent, value);
						}
						remove
						{
							CodeChangedEvent = (EventHandler) System.Delegate.Remove(CodeChangedEvent, value);
						}
					}
					
					
					/// <summary>
					/// Raises the CodeChanged event.
					/// </summary>
					/// <remarks></remarks>
					protected virtual void OnCodeChanged()
					{
						if (CodeChangedEvent != null)
							CodeChangedEvent(this, EventArgs.Empty);
					}
					
					/// <summary>
					/// Occurs when the return value of the PrimaryKey property changes.
					/// </summary>
					/// <remarks></remarks>
					private EventHandler PrimaryKeyChangedEvent;
					public event EventHandler PrimaryKeyChanged
					{
						add
						{
							PrimaryKeyChangedEvent = (EventHandler) System.Delegate.Combine(PrimaryKeyChangedEvent, value);
						}
						remove
						{
							PrimaryKeyChangedEvent = (EventHandler) System.Delegate.Remove(PrimaryKeyChangedEvent, value);
						}
					}
					
					
					/// <summary>
					/// Raises the PrimaryKeyChanged event.
					/// </summary>
					/// <remarks></remarks>
					protected virtual void OnPrimaryKeyChanged()
					{
						if (PrimaryKeyChangedEvent != null)
							PrimaryKeyChangedEvent(this, EventArgs.Empty);
					}
					
					#endregion
					
					#region " Handled Events "
					
					private void cmdBrowse_Click(System.Object sender, System.EventArgs e)
					{
						//-- Show the browse dialog
						if (PeopleBrowse.ShowDialog() == DialogResult.OK)
						{
							this.txtCode.Text = People.pl_Code;
						}
					}
					
					#endregion
					
					#region " IBusinessBindable Implementation "
					
					private BusinessLayer _BusinessObject;
					private string _BindingField = "";
					private string _BindingFormat = "";
					private string _BindingProperty = "PrimaryKey";
					private bool _IgnoreManageUIReadOnlyState = true;
					private DataSourceUpdateMode _BindingUpdateMode = DataSourceUpdateMode.OnPropertyChanged;
					private ControlUpdateMode _ControlSourceUpdateMode = ControlUpdateMode.OnPropertyChanged;
					
					/// <summary>
					/// The field within the business object that is bound to the control
					/// </summary>
					[Category(BusinessMod.EDITOR_CATEGORY),
                    Description(BusinessMod.EDITOR_BINDINGUPDATEMODE_DESC)]
                    public DataSourceUpdateMode DataSourceUpdateMode
					{
						get
						{
							return this.BindingUpdateMode;
						}
						set
						{
							this.BindingUpdateMode = value;
						}
					}
					
					public DataSourceUpdateMode BindingUpdateMode
					{
						get
						{
							return _BindingUpdateMode;
						}
						set
						{
							_BindingUpdateMode = value;
						}
					}
					
					/// <summary>
					/// The field within the business object that is bound to the control
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
                    [Category(BusinessMod.EDITOR_CATEGORY), 
                    DefaultValue(""),
                    Description(BusinessMod.EDITOR_BINDINGFIELD_DESC), 
                    Editor(MicroFour.StrataFrame.Extensibility.Constants.TE_BindingFieldEditor, typeof(UITypeEditor))]
                    public string BindingField
					{
						get
						{
							return _BindingField;
						}
						set
						{
							_BindingField = value;
						}
					}
					
					/// <summary>
					/// The business object that is used to bind the data to this field
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
                    [Category(BusinessMod.EDITOR_CATEGORY), 
                    DefaultValue(null),
                    Description(BusinessMod.EDITOR_BUSINESSOBJECT_DESC)]
                    public BusinessLayerBase BusinessObject
					{
						get
						{
							return this._BusinessObject;
						}
						set
						{
							//-- If the business object is being removed, then make sure it is no longer bound
							if ((value == null) && (_BusinessObject != null))
							{
								this._BusinessObject.RemoveFromListOfBoundControls(this);
							}
							
							if ((! this.DesignMode) && (value != null))
							{
								value.AddToListOfBoundControls(this);
							}
							
							_BusinessObject = (BusinessLayer) value;
						}
					}
					
					/// <summary>
					/// The property on this control to which the data is bound.
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
                    [Category(BusinessMod.EDITOR_CATEGORY), 
                    DefaultValue("PrimaryKey"),
                    Description(BusinessMod.EDITOR_BINDINGPROPERTY_DESC), 
                    Editor(MicroFour.StrataFrame.Extensibility.Constants.TE_BindingPropertyEditor, typeof(UITypeEditor))]
                    public string BindingProperty
					{
						get
						{
							return _BindingProperty;
						}
						set
						{
							_BindingProperty = value;
						}
					}
					
					/// <summary>
					/// If True, the control will ignore that auto manage editing state of the business object.  The control will not
					/// be automatically enabled/disabled by the business object.
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
                    [Category(BusinessMod.EDITOR_CATEGORY), 
                    DefaultValue(true),
                    Description(BusinessMod.EDITOR_IGNOREMANAGE_DESC)]
                    public bool IgnoreManageUIReadOnlyState
					{
						get
						{
							return this.IgnoreManageReadOnlyState;
						}
						set
						{
							this.IgnoreManageReadOnlyState = value;
						}
					}
					
					public bool IgnoreManageReadOnlyState
					{
						get
						{
							return _IgnoreManageUIReadOnlyState;
						}
						set
						{
							_IgnoreManageUIReadOnlyState = value;
						}
					}
					
					/// <summary>
					/// The formst string used to format the data that is bound to the control
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
                    [Description(BusinessMod.EDITOR_BINDINGFORMAT_DESC),
                    Category(BusinessMod.EDITOR_CATEGORY), 
                    DefaultValue("")]
                    public string BindingFormat
					{
						get
						{
							return _BindingFormat;
						}
						set
						{
							_BindingFormat = value;
						}
					}
					
					/// <summary>
					/// Makes the control available or unavailable for editing
					/// </summary>
					/// <value></value>
					/// <remarks></remarks>
					[Browsable(false)]public bool BindingEditable
					{
						get
						{
							return this.Enabled;
						}
						set
						{
							this.Enabled = value;
						}
					}
					
					/// <summary>
					/// Gets or sets a value that determines whether the control will allow
					/// its editable state to be managed by the bound business object.
					/// </summary>
					/// <value></value>
					/// <returns></returns>
					/// <remarks></remarks>
                    [Category(BusinessMod.EDITOR_CATEGORY),
                    Description(BusinessMod.EDITOR_CONTROLUPDATEMODE_DESC)]
                    public System.Windows.Forms.ControlUpdateMode ControlSourceUpdateMode
					{
						get
						{
							return this._ControlSourceUpdateMode;
						}
						set
						{
							this._ControlSourceUpdateMode = value;
						}
					}
					
					private void ResetControlSourceUpdateMode()
					{
						this._ControlSourceUpdateMode = ControlUpdateMode.OnPropertyChanged;
					}
					
					private bool ShouldSerializeControlSourceUpdateMode()
					{
						return this._ControlSourceUpdateMode != ControlUpdateMode.OnPropertyChanged;
					}
					
					/// <summary>
					/// Determines if the binding update mode property is set to default
					/// </summary>
					/// <returns></returns>
					/// <remarks></remarks>
					public bool ShouldSerializeBindingUpdateMode()
					{
						return _BindingUpdateMode != DataSourceUpdateMode.OnPropertyChanged;
					}
					
					/// <summary>
					/// Resets the binding update mode
					/// </summary>
					/// <remarks></remarks>
					public void ResetBindingUpdateMode()
					{
						_BindingUpdateMode = DataSourceUpdateMode.OnPropertyChanged;
					}
					
					#endregion
					
					#region " Private Fields "
					
					private string _Code = "";
					private bool _IsLoading = false;
					private int _PrimaryKey = 0;
					
					#endregion
					
					#region " Private Methods "
					
					/// <summary>
					/// Loads the person into the control
					/// </summary>
					/// <remarks></remarks>
					private void LoadPerson(string peopleCode)
					{
						//-- Incidate that a load is taking place
						_IsLoading = true;
						
						//-- Update the primary key
						PrimaryKey = PeopleBO.GetPrimaryKeyByCode(peopleCode);
						this.lblDesc.Text = PeopleBO.GetFullName(_PrimaryKey);
						
						//-- Allow updates again
						_IsLoading = false;
					}
					
					/// <summary>
					/// Loads the person into the control
					/// </summary>
					/// <remarks></remarks>
					private void LoadPerson(int personPk)
					{
						//-- Establish Locals
						string peopleCode = "";
						
						//-- Incidate that a load is taking place
						_IsLoading = true;
						
						try
						{
							peopleCode = PeopleBO.GetCodeByPrimaryKey(personPk);
							this.lblDesc.Text = PeopleBO.GetFullName(personPk);
						}
						catch (Exception)
						{
							peopleCode = "";
							this.lblDesc.Text = "";
						}
						
						//-- Update the code
						Code = peopleCode;
						
						//-- Allow updates again
						_IsLoading = false;
					}
					
					#endregion
					
					#region " Public Properties "
					
					/// <summary>
					/// The code assocaited with the loaded record
					/// </summary>
					public string Code
					{
						get
						{
							return this._Code;
						}
						set
						{
							if (! value.Equals(_Code))
							{
								this._Code = value;
								
								//-- Determine if the code should be loaded
								if (! _IsLoading)
								{
									this.LoadPerson(value);
								}
								
								OnCodeChanged();
							}
						}
					}
					
					/// <summary>
					/// The primary key of the currently loaded record
					/// </summary>
					[Browsable(false)][DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public int PrimaryKey
					{
						get
						{
							return this._PrimaryKey;
						}
						set
						{
							if (value != _PrimaryKey)
							{
								this._PrimaryKey = value;
								
								//-- Determine if the code should be loaded
								if (! _IsLoading)
								{
									this.LoadPerson(value);
								}
								
								OnPrimaryKeyChanged();
							}
						}
					}
					
					#endregion
					
				}
				
			}
		}
	}
}
